package parser;

/**
 * End of file token class.
 */
public class EOFToken extends AToken {
    /**
     * Interface for a visitor to visit an eof token.
     */
    public static interface IEOFVisitor extends ITokVisitor {
        /**
         * Case for an eof token.
         *
         * @param host  eof token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object eofCase(EOFToken host, Object param);
    }

    /**
     * Singleton instance.
     */
    public final static EOFToken Singleton = new EOFToken();

    /**
     * Private singleton constructor.
     */
    private EOFToken() {
        super("EOF");
    }

    /**
     * Execute the eof case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IEOFVisitor) ?
               ((IEOFVisitor) algo).eofCase(this, param) :
               algo.defaultCase(this, param);
    }
}

